###############################################################################
# chatGPT.tcl
# v1.3.17 (27/01/2026)  ©2025-2026 Te[u]K  (avec l'aide de MenzAgitat)
# https://teuk.org
###############################################################################
# Public : !chatgpt <prompt>
# Privé  : /msg <BotNick> chatgpt <prompt>
# Aux (si +chatgpt sur chan) :
#   !gptreset
#   !gptset hist <n>
#   !gptset chars <n>
#   !gptset answerchars <n>   (limite dure en caracteres de la reponse)
#   !gptset prompt <texte...> (prompt SYSTEM persistant par chan; vide = reset défaut)
#   !gptecho <user|assistant> <texte>
#
###############################################################################

if {[info commands ::teuk::chatgpt::unload] eq "::teuk::chatgpt::unload"} { catch { ::teuk::chatgpt::unload } }
if { [lindex [split $::version] 1] < 1080404 } { putloglev o * "\00304\[chatgpt - erreur\]\003 Eggdrop trop ancien: \00304${::version}\003 (>= 1.8.4 requis). Chargement annulé."; return }
if { [catch { package require Tcl 8.6 }] } { putloglev o * "\00304\[chatgpt - erreur\]\003 Tcl 8.6+ requis. Version actuelle: \00304${::tcl_version}\003. Chargement annulé."; return }
if { [catch { package require tls } terr] } { putloglev o * "\00304\[chatgpt - erreur\]\003 package Tcl 'tls' requis pour HTTPS (tcl-tls). Erreur: \00304$terr\003. Chargement annulé."; return }

package provide chatgpt 1.3.17

namespace eval ::teuk::chatgpt {
    variable version "1.3.17"
    variable debug  3

    # IMPORTANT: NE LAISSE PAS UNE VRAIE CLE ICI (rotate celle qui a fuité)
    variable api_key "YOUR_API_KEY_HERE"
    variable api_url "https://api.openai.com/v1/chat/completions"
    variable model "gpt-4o-mini"
    variable temperature 0.5
    variable max_tokens 400
    variable max_answer_chars 0

    variable use_wrapper_https 1
    variable wrapper_url "https://r.jina.ai/http://"

    variable http_decode_utf8  1

    variable use_curl_fallback 1
    variable curl_bin "curl"
    variable curl_timeout 30

    variable prefer_curl 1

    variable max_privmsg 6
    variable trunc_msg  " ...<truncated>"
    variable sleep_ms   600

    variable hist_max_msgs  10
    variable hist_max_chars 3500

    variable HAVE_JSON 0
    variable HAVE_JSON_WRITE 0
    variable HAVE_TLS  1
    variable HAVE_HTTP 0

    variable hist
    variable hist_overrides

    variable system_prompt "Tu es un assistant utile, concis et fiable. Réponds en français sauf demande contraire."

    variable prompt_db_file "chatgpt_prompts.db"
    variable prompt_db_migrated 0
    array set system_prompt_overrides {}
}

# ---- deps ----
if {![catch {package require http} e]} {
    set ::teuk::chatgpt::HAVE_HTTP 1
} else {
    putloglev o * "\00304\[chatgpt - erreur\]\003 package Tcl 'http' requis. Erreur: \00304$e\003. Chargement annulé."
    return
}

if {![catch {package require json} e]} {
    set ::teuk::chatgpt::HAVE_JSON 1
    if {[info commands ::json::write] ne ""} {
        set ::teuk::chatgpt::HAVE_JSON_WRITE 1
    } else {
        set ::teuk::chatgpt::HAVE_JSON_WRITE 0
        putloglev o * "\00307\[chatgpt - warning\]\003 json present mais sans json::write; fallback builder JSON actif."
    }
} else {
    set ::teuk::chatgpt::HAVE_JSON 0
    set ::teuk::chatgpt::HAVE_JSON_WRITE 0
    putloglev o * "\00307\[chatgpt - warning\]\003 package Tcl 'json' introuvable; fallback regex JSON actif (moins robuste)."
}

if {[catch {set ::teuk::chatgpt::HAVE_TLS 1}]} { set ::teuk::chatgpt::HAVE_TLS 0 }
if {$::teuk::chatgpt::HAVE_TLS} { catch { ::http::register https 443 ::tls::socket } }

if {[llength [info commands setudef]]} { catch { setudef flag chatgpt } }

# ---- logs ----
proc ::teuk::chatgpt::log1 {msg} { if {$::teuk::chatgpt::debug >= 1} { putloglev o * "\00310\[chatgpt\]\003 $msg" } }
proc ::teuk::chatgpt::log2 {msg} { if {$::teuk::chatgpt::debug >= 2} { putloglev o * "\00314\[chatgpt\]\003 $msg" } }
proc ::teuk::chatgpt::log3 {msg} { if {$::teuk::chatgpt::debug >= 3} { putloglev o * "\00313\[chatgpt dbg\]\003 $msg" } }

proc ::teuk::chatgpt::unload {} {
    catch {unbind pubm -|- * ::teuk::chatgpt::pubm}
    catch {unbind msg  -|- chatgpt ::teuk::chatgpt::msg_chatgpt}
    catch {unbind msg  -|- gptreset ::teuk::chatgpt::msg_aux}
    catch {unbind msg  -|- gptset   ::teuk::chatgpt::msg_aux}
    catch {unbind msg  -|- gptecho  ::teuk::chatgpt::msg_aux}
    catch {unbind evnt - prerehash ::teuk::chatgpt::unload}
    if {[llength [info commands unsetudef]]} { catch { unsetudef flag chatgpt } }
    catch {namespace delete ::teuk::chatgpt}
}

# ---- helpers ----
proc ::teuk::chatgpt::_llength_safe {x} { if {[catch {llength $x} n]} { return -1 } ; return $n }
proc ::teuk::chatgpt::_preview {s {n 220}} {
    set t [string map [list "\n" "\\n" "\r" "\\r" "\t" "\\t"] $s]
    return [string range $t 0 $n]
}
proc ::teuk::chatgpt::_hex80 {s} {
    set b [encoding convertto utf-8 $s]
    set b [string range $b 0 79]
    binary scan $b H* hex
    return $hex
}
proc ::teuk::chatgpt::_errinfo_one {s} {
    set t [string map [list "\n" " | " "\r" "" "\t" " "] $s]
    return [string range $t 0 380]
}

# --- persistence (prompts) ---
proc ::teuk::chatgpt::_db_path {} { return [file normalize $::teuk::chatgpt::prompt_db_file] }

proc ::teuk::chatgpt::_db_quarantine {reason} {
    set f [::teuk::chatgpt::_db_path]
    if {![file exists $f]} { return }
    set ts [clock format [clock seconds] -format "%Y%m%d-%H%M%S"]
    set bad "${f}.bad.${ts}"
    catch { file rename -force $f $bad }
    ::teuk::chatgpt::log1 "prompt db corrompue -> quarantine: $bad (reason: $reason)"
}

proc ::teuk::chatgpt::_db_load {} {
    set f [::teuk::chatgpt::_db_path]
    if {![file exists $f]} { ::teuk::chatgpt::log2 "prompt db absent: $f"; return }

    if {[catch {
        set fh [open $f r]
        set data [read $fh]
        close $fh
    } e]} {
        ::teuk::chatgpt::log1 "prompt db read failed: $e"
        return
    }

    set data [string trim $data]
    if {$data eq ""} { return }

    if {![catch {
        set alist [lindex $data 0]
        if {[expr {[llength $alist] % 2}] != 0} { error "odd-length alist" }
        array unset ::teuk::chatgpt::system_prompt_overrides
        array set  ::teuk::chatgpt::system_prompt_overrides $alist
    } e1]} {
        ::teuk::chatgpt::log1 "prompt db loaded (array): [expr {[array size ::teuk::chatgpt::system_prompt_overrides]}] override(s)"
        return
    } else {
        ::teuk::chatgpt::log3 "prompt db new-format load failed: $e1 (data head=[::teuk::chatgpt::_preview $data 160])"
    }

    set d ""
    set ok 0
    if {!$ok} {
        if {![catch {
            set d1 [lindex $data 0]
            dict size $d1
            set d $d1
            set ok 1
        } _e]} {}
    }
    if {!$ok} {
        if {![catch {
            dict size $data
            set d $data
            set ok 1
        } _e]} {}
    }

    if {!$ok} { ::teuk::chatgpt::_db_quarantine "unparseable prompt db"; return }

    array unset ::teuk::chatgpt::system_prompt_overrides
    dict for {k v} $d { set ::teuk::chatgpt::system_prompt_overrides($k) $v }
    set ::teuk::chatgpt::prompt_db_migrated 1
    ::teuk::chatgpt::log1 "prompt db loaded (dict->array migration): [expr {[array size ::teuk::chatgpt::system_prompt_overrides]}] override(s)"
    catch { ::teuk::chatgpt::_db_save }
}

proc ::teuk::chatgpt::_db_save {} {
    set f [::teuk::chatgpt::_db_path]
    set dir [file dirname $f]
    if {![file isdirectory $dir]} {
        if {[catch { file mkdir $dir } e]} { ::teuk::chatgpt::log1 "prompt db mkdir failed ($dir): $e"; return -code error $e }
    }

    set tmp "${f}.tmp.[pid]"
    set alist [array get ::teuk::chatgpt::system_prompt_overrides]

    if {[catch {
        set fh [open $tmp w]
        catch { file attributes $tmp -permissions 0600 }
        puts -nonewline $fh [list $alist]
        close $fh
        file rename -force $tmp $f
        catch { file attributes $f -permissions 0600 }
    } e]} {
        catch { close $fh }
        catch { file delete -force $tmp }
        ::teuk::chatgpt::log1 "prompt db save failed: $e"
        return -code error $e
    }

    ::teuk::chatgpt::log2 "prompt db saved: $f"
}

proc ::teuk::chatgpt::_answer_max_chars {target} {
    set maxa $::teuk::chatgpt::max_answer_chars
    if {[info exists ::teuk::chatgpt::hist_overrides($target)]} {
        set o $::teuk::chatgpt::hist_overrides($target)
        if {[dict exists $o max_answer_chars]} { set maxa [dict get $o max_answer_chars] }
    }
    return $maxa
}

proc ::teuk::chatgpt::_system_prompt {target} {
    if {[info exists ::teuk::chatgpt::system_prompt_overrides($target)]} {
        set sp $::teuk::chatgpt::system_prompt_overrides($target)
        if {[string trim $sp] ne ""} { return $sp }
    }
    return $::teuk::chatgpt::system_prompt
}

proc ::teuk::chatgpt::_set_system_prompt {target newprompt} {
    set newprompt [string trim $newprompt]
    if {$newprompt eq ""} {
        catch { unset ::teuk::chatgpt::system_prompt_overrides($target) }
        if {[catch { ::teuk::chatgpt::_db_save } e]} { return "WARN reset OK, mais save a échoué: $e" }
        return "OK prompt reset (défaut)"
    }
    set ::teuk::chatgpt::system_prompt_overrides($target) $newprompt
    if {[catch { ::teuk::chatgpt::_db_save } e]} { return "WARN prompt mis à jour, mais save a échoué: $e" }
    return "OK prompt system mis à jour (persistant)"
}

proc ::teuk::chatgpt::_truncate_answer {s maxa} {
    if {$maxa <= 0} { return $s }
    if {[string length $s] <= $maxa} { return $s }
    set suffix $::teuk::chatgpt::trunc_msg
    set keep [expr {$maxa - [string length $suffix]}]
    if {$keep < 20} { set keep 20 }
    set cut [string range $s 0 $keep]
    set w [string last " " $cut]
    if {$w > 0} { set cut [string range $cut 0 $w] }
    return "[string trimright $cut]$suffix"
}

proc ::teuk::chatgpt::_rewrite_url {url} {
    if {!$::teuk::chatgpt::use_wrapper_https} { return $url }
    if {[string match -nocase "https://api.openai.com/*" $url]} { return $url }
    if {[string match -nocase "https://*" $url]} {
        set u [string range $url 8 end]
        return "$::teuk::chatgpt::wrapper_url$u"
    }
    return $url
}

# --- Historique en paires {role content} ---
proc ::teuk::chatgpt::_hist_sanitize {target} {
    if {![info exists ::teuk::chatgpt::hist($target)]} { return 1 }
    set hn [::teuk::chatgpt::_llength_safe $::teuk::chatgpt::hist($target)]
    if {$hn < 0} {
        ::teuk::chatgpt::log1 "hist($target) CORRUPT (not list) -> reset. head=[::teuk::chatgpt::_preview $::teuk::chatgpt::hist($target) 180] hex80=[::teuk::chatgpt::_hex80 $::teuk::chatgpt::hist($target)]"
        set ::teuk::chatgpt::hist($target) {}
        return 0
    }
    set cleaned {}
    set drops 0
    set i 0
    foreach m $::teuk::chatgpt::hist($target) {
        incr i
        set ml [::teuk::chatgpt::_llength_safe $m]
        if {$ml < 0} { incr drops; continue }
        if {$ml == 2} { lappend cleaned $m; continue }
        if {![catch {set r [dict get $m role]}] && ![catch {set c [dict get $m content]}]} {
            lappend cleaned [list $r $c]
            continue
        }
        incr drops
    }
    if {$drops > 0} {
        set ::teuk::chatgpt::hist($target) $cleaned
        ::teuk::chatgpt::log1 "hist($target) sanitized: dropped=$drops kept=[llength $cleaned]"
        return 0
    }
    return 1
}

proc ::teuk::chatgpt::_hist_add {target role content} {
    if {![info exists ::teuk::chatgpt::hist($target)]} { set ::teuk::chatgpt::hist($target) {} }
    catch { ::teuk::chatgpt::_hist_sanitize $target }
    lappend ::teuk::chatgpt::hist($target) [list $role $content]

    set max_msgs  $::teuk::chatgpt::hist_max_msgs
    set max_chars $::teuk::chatgpt::hist_max_chars
    if {[info exists ::teuk::chatgpt::hist_overrides($target)]} {
        set o $::teuk::chatgpt::hist_overrides($target)
        if {[dict exists $o max_msgs]}  { set max_msgs  [dict get $o max_msgs] }
        if {[dict exists $o max_chars]} { set max_chars [dict get $o max_chars] }
    }

    while {[llength $::teuk::chatgpt::hist($target)] > $max_msgs} {
        set ::teuk::chatgpt::hist($target) [lrange $::teuk::chatgpt::hist($target) 1 end]
    }

    set tot 0
    foreach m $::teuk::chatgpt::hist($target) {
        if {[::teuk::chatgpt::_llength_safe $m] != 2} { continue }
        incr tot [string length [lindex $m 1]]
    }
    while {$tot > $max_chars && [llength $::teuk::chatgpt::hist($target)] > 1} {
        set m [lindex $::teuk::chatgpt::hist($target) 0]
        if {[::teuk::chatgpt::_llength_safe $m] == 2} { incr tot -[string length [lindex $m 1]] }
        set ::teuk::chatgpt::hist($target) [lrange $::teuk::chatgpt::hist($target) 1 end]
    }
}

# --- JSON escape (fallback uniquement) ---
proc ::teuk::chatgpt::_json_escape {s} {
    return [string map [list "\\" "\\\\" "\"" "\\\"" "\n" "\\n" "\r" "\\r" "\t" "\\t"] $s]
}

# --- Payload builder ---
proc ::teuk::chatgpt::_make_payload {target} {
    catch { ::teuk::chatgpt::_hist_sanitize $target }
    set sp [::teuk::chatgpt::_system_prompt $target]

    set pairs {}
    lappend pairs [list system $sp]
    if {[info exists ::teuk::chatgpt::hist($target)]} {
        foreach m $::teuk::chatgpt::hist($target) {
            if {[::teuk::chatgpt::_llength_safe $m] == 2} { lappend pairs $m }
        }
    }

    # --- json::write si dispo ---
    if {$::teuk::chatgpt::HAVE_JSON_WRITE} {
        if {[catch {
            set msgObjs {}
            foreach p $pairs {
                set role [lindex $p 0]
                set cont [lindex $p 1]
                lappend msgObjs [::json::write object role $role content $cont]
            }
            set payload [::json::write object \
                model $::teuk::chatgpt::model \
                temperature $::teuk::chatgpt::temperature \
                max_tokens $::teuk::chatgpt::max_tokens \
                messages [::json::write array {*}$msgObjs] \
            ]
        } e]} {
            ::teuk::chatgpt::log1 "json::write payload failed: $e"
            return -code error $e
        }
        ::teuk::chatgpt::log3 "payload ok(json::write): target=$target pairs=[llength $pairs] bytes=[string length $payload]"
        ::teuk::chatgpt::log3 "payload head: [string range $payload 0 280]"
        return $payload
    }

    # --- fallback MANUEL SANS AUCUN \" DANS LE CODE Tcl ---
    # (c’est CA qui corrige ton plantage sur append out "\"messages\":[")
    set mModel [::teuk::chatgpt::_json_escape $::teuk::chatgpt::model]

    set out ""
    append out "{"
    append out {"model":"}
    append out $mModel
    append out {",}

    append out {"temperature":}
    append out $::teuk::chatgpt::temperature
    append out {,}

    append out {"max_tokens":}
    append out $::teuk::chatgpt::max_tokens
    append out {,}

    append out {"messages":[}

    set first 1
    foreach p $pairs {
        set r [::teuk::chatgpt::_json_escape [lindex $p 0]]
        set c [::teuk::chatgpt::_json_escape [lindex $p 1]]
        if {!$first} { append out "," } else { set first 0 }
        append out "{"
        append out {"role":"}
        append out $r
        append out {","content":"}
        append out $c
        append out {"}
        append out "}"
    }

    append out "]}"
    ::teuk::chatgpt::log3 "payload ok(fallback): target=$target pairs=[llength $pairs] bytes=[string length $out]"
    ::teuk::chatgpt::log3 "payload head: [string range $out 0 280]"
    return $out
}

# ---- curl ----
proc ::teuk::chatgpt::_call_api_curl {url key payload_utf8} {
    set curl $::teuk::chatgpt::curl_bin
    set cmd [list $curl \
        --silent --show-error \
        --max-time $::teuk::chatgpt::curl_timeout \
        --http1.1 \
        -H "Authorization: Bearer $key" \
        -H "Content-Type: application/json; charset=utf-8" \
        -H "Accept: application/json" \
        --data-binary $payload_utf8 \
        $url]
    ::teuk::chatgpt::log2 "curl: [lindex $cmd 0] --http1.1 ... $url"
    if {[catch { set out [exec {*}$cmd] } e]} { return -code error "curl failed: $e" }
    return $out
}

proc ::teuk::chatgpt::_call_api {payload} {
    set key [string trim $::teuk::chatgpt::api_key]
    if {$key eq "" || $key eq "YOUR_API_KEY_HERE"} { return -code error "api_key vide / non configurée" }

    set url [::teuk::chatgpt::_rewrite_url $::teuk::chatgpt::api_url]
    set body_utf8 [encoding convertto utf-8 $payload]
    ::teuk::chatgpt::log2 "API POST $url (payload_bytes=[string length $payload])"

    if {$::teuk::chatgpt::prefer_curl} {
        set raw [::teuk::chatgpt::_call_api_curl $url $key $body_utf8]
        if {$::teuk::chatgpt::http_decode_utf8} { catch { set raw [encoding convertfrom utf-8 $raw] } }
        return $raw
    }

    if {[catch {
        set headers [list Authorization "Bearer $key" Content-Type "application/json; charset=utf-8" Accept "application/json"]
        set tok [::http::geturl $url -method POST -headers $headers -type "application/json; charset=utf-8" -query $body_utf8 -timeout 30000 -strict 1 -binary 1]
    } e]} {
        if {$::teuk::chatgpt::use_curl_fallback} {
            ::teuk::chatgpt::log1 "http geturl failed, curl fallback: $e"
            set raw [::teuk::chatgpt::_call_api_curl $url $key $body_utf8]
            if {$::teuk::chatgpt::http_decode_utf8} { catch { set raw [encoding convertfrom utf-8 $raw] } }
            return $raw
        }
        return -code error "http geturl failed: $e"
    }

    set stat [::http::status $tok]
    set code [::http::ncode  $tok]
    set raw  [::http::data   $tok]
    ::http::cleanup $tok

    if {$::teuk::chatgpt::http_decode_utf8} { catch { set raw [encoding convertfrom utf-8 $raw] } }
    if {$stat ne "ok"} { return -code error "http $stat (code $code)" }
    if {$code < 200 || $code >= 300} { return -code error "http $code: $raw" }
    return $raw
}

proc ::teuk::chatgpt::_parse_answer {response} {
    if {$::teuk::chatgpt::HAVE_JSON} {
        set d [json::json2dict $response]
        set first [lindex [dict get $d choices] 0]
        return [string trim [dict get [dict get $first message] content]]
    }
    if {[regexp {\"content\"\s*:\s*\"((?:\\.|[^\"\\])*)\"} $response -> m]} {
        set m [string map [list "\\n" "\n" "\\r" "\r" "\\t" "\t" "\\\\" "\\" "\\\"" "\""] $m]
        return [string trim $m]
    }
    return -code error "invalid JSON response"
}

proc ::teuk::chatgpt::_wrap {target text} {
    set max 430
    set text [string trim $text]
    set out {}
    while {[string length $text] > 0} {
        if {[string length $text] <= $max} { lappend out $text; break }
        set slice [string range $text 0 $max]
        set cut [string last " " $slice]
        if {$cut < 0} { set cut $max }
        lappend out [string trimright [string range $text 0 $cut]]
        set text [string trimleft [string range $text [expr {$cut+1}] end]]
    }
    return $out
}

proc ::teuk::chatgpt::_send {target chunks} {
    set L $chunks
    if {[llength $L] > $::teuk::chatgpt::max_privmsg} {
        set last [expr {$::teuk::chatgpt::max_privmsg - 1}]
        set c [lindex $L $last]
        set allow [expr {[string length $c] - [string length $::teuk::chatgpt::trunc_msg]}]
        if {$allow < 20} { set allow 20 }
        set c [string range $c 0 $allow]
        set cut [string last " " $c]
        if {$cut > 0} { set c [string range $c 0 $cut] }
        set L [lreplace $L $last end "[string trimright $c]$::teuk::chatgpt::trunc_msg"]
    }
    foreach line $L {
        if {$line eq ""} { continue }
        puthelp "PRIVMSG $target :$line"
        after $::teuk::chatgpt::sleep_ms
    }
}

proc ::teuk::chatgpt::_handle {nick target prompt} {
    set prompt [regsub -all {\s+} [string trim $prompt] " "]
    if {$prompt eq ""} { puthelp "NOTICE $nick :Syntaxe: !chatgpt <prompt>"; return }

    ::teuk::chatgpt::log3 "handle: nick=$nick target=$target prompt_len=[string length $prompt]"
    ::teuk::chatgpt::_hist_add $target user $prompt

    if {[catch { set payload [::teuk::chatgpt::_make_payload $target] } e]} {
        set ei ""; set ec ""
        catch { set ei $::errorInfo }
        catch { set ec $::errorCode }
        ::teuk::chatgpt::log1 "payload error: $e"
        ::teuk::chatgpt::log3 "payload errorInfo: [::teuk::chatgpt::_errinfo_one $ei]"
        ::teuk::chatgpt::log3 "payload errorCode: $ec"

        if {$::teuk::chatgpt::debug >= 3 && [info exists ::teuk::chatgpt::hist($target)]} {
            ::teuk::chatgpt::log3 "debug: hist_raw_head=[::teuk::chatgpt::_preview $::teuk::chatgpt::hist($target) 220]"
            ::teuk::chatgpt::log3 "debug: hist_raw_hex80=[::teuk::chatgpt::_hex80 $::teuk::chatgpt::hist($target)]"
            ::teuk::chatgpt::log3 "debug: hist_llength_safe=[::teuk::chatgpt::_llength_safe $::teuk::chatgpt::hist($target)]"
        }

        puthelp "NOTICE $nick :Erreur interne (payload)"
        return
    }

    if {[catch { set resp [::teuk::chatgpt::_call_api $payload] } e]} {
        ::teuk::chatgpt::log1 "API error: $e"
        puthelp "NOTICE $nick :API indisponible."
        return
    }

    if {[catch { set ans [::teuk::chatgpt::_parse_answer $resp] } e]} {
        ::teuk::chatgpt::log1 "parse error: $e"
        puthelp "NOTICE $nick :Réponse API illisible."
        return
    }

    set ans [regsub -all {[\r\n]+} $ans " "]
    set ans [regsub -all {\s{2,}}  $ans " "]
    set ans [string trim $ans]

    set maxa [::teuk::chatgpt::_answer_max_chars $target]
    set ans  [::teuk::chatgpt::_truncate_answer $ans $maxa]

    ::teuk::chatgpt::_hist_add $target assistant $ans
    ::teuk::chatgpt::_send $target [::teuk::chatgpt::_wrap $target $ans]
}

# --- Binds ---
proc ::teuk::chatgpt::pubm {nick uhost hand chan text} {
    if {![channel get $chan chatgpt]} { return }

    if {[regexp -nocase -- {^!chatgpt\s+(.+)$} $text -> q]} { ::teuk::chatgpt::_handle $nick $chan $q; return }
    if {[regexp -nocase -- {^!gptreset\s*$} $text]} { unset -nocomplain ::teuk::chatgpt::hist($chan); puthelp "PRIVMSG $chan :OK historique reinitialise pour $chan"; return }

    if {[regexp -nocase -- {^!gptset\s+hist\s+(\d+)\s*$} $text -> n]} {
        set cur [dict create]
        if {[info exists ::teuk::chatgpt::hist_overrides($chan)]} { set cur $::teuk::chatgpt::hist_overrides($chan) }
        set ::teuk::chatgpt::hist_overrides($chan) [dict merge $cur [dict create max_msgs $n]]
        puthelp "PRIVMSG $chan :OK hist_max_msgs=$n pour $chan"
        return
    }

    if {[regexp -nocase -- {^!gptset\s+chars\s+(\d+)\s*$} $text -> n]} {
        set cur [dict create]
        if {[info exists ::teuk::chatgpt::hist_overrides($chan)]} { set cur $::teuk::chatgpt::hist_overrides($chan) }
        set ::teuk::chatgpt::hist_overrides($chan) [dict merge $cur [dict create max_chars $n]]
        puthelp "PRIVMSG $chan :OK hist_max_chars=$n pour $chan"
        return
    }

    if {[regexp -nocase -- {^!gptset\s+answerchars\s+(\d+)\s*$} $text -> n]} {
        set cur [dict create]
        if {[info exists ::teuk::chatgpt::hist_overrides($chan)]} { set cur $::teuk::chatgpt::hist_overrides($chan) }
        set ::teuk::chatgpt::hist_overrides($chan) [dict merge $cur [dict create max_answer_chars $n]]
        puthelp "PRIVMSG $chan :OK max_answer_chars=$n pour $chan"
        return
    }

    if {[regexp -nocase -- {^!gptset\s+prompt(?:\s+(.*))?\s*$} $text -> p]} {
        if {![info exists p]} { set p "" }
        set r [::teuk::chatgpt::_set_system_prompt $chan $p]
        puthelp "PRIVMSG $chan :$r (chan=$chan)"
        return
    }

    if {[regexp -nocase -- {^!gptecho\s+(user|assistant)\s+(.+)$} $text -> role payload]} {
        ::teuk::chatgpt::_hist_add $chan $role $payload
        puthelp "PRIVMSG $chan :INFO ajoute au contexte ($role): [string range $payload 0 80]"
        return
    }
}
bind pubm -|- * ::teuk::chatgpt::pubm

proc ::teuk::chatgpt::msg_chatgpt {nick uhost hand text} {
    if {$text eq ""} { puthelp "NOTICE $nick :Syntaxe: chatgpt <prompt>"; return }
    ::teuk::chatgpt::_handle $nick $nick $text
}
bind msg -|- chatgpt ::teuk::chatgpt::msg_chatgpt

proc ::teuk::chatgpt::msg_aux {nick uhost hand text} {
    if {[regexp -nocase -- {^gptreset\s*$} $text]} { unset -nocomplain ::teuk::chatgpt::hist($nick); puthelp "NOTICE $nick :Historique reinitialise pour $nick"; return }

    if {[regexp -nocase -- {^gptset\s+hist\s+(\d+)\s*$} $text -> n]} {
        set cur [dict create]
        if {[info exists ::teuk::chatgpt::hist_overrides($nick)]} { set cur $::teuk::chatgpt::hist_overrides($nick) }
        set ::teuk::chatgpt::hist_overrides($nick) [dict merge $cur [dict create max_msgs $n]]
        puthelp "NOTICE $nick :hist_max_msgs=$n pour $nick"
        return
    }

    if {[regexp -nocase -- {^gptset\s+chars\s+(\d+)\s*$} $text -> n]} {
        set cur [dict create]
        if {[info exists ::teuk::chatgpt::hist_overrides($nick)]} { set cur $::teuk::chatgpt::hist_overrides($nick) }
        set ::teuk::chatgpt::hist_overrides($nick) [dict merge $cur [dict create max_chars $n]]
        puthelp "NOTICE $nick :hist_max_chars=$n pour $nick"
        return
    }

    if {[regexp -nocase -- {^gptset\s+answerchars\s+(\d+)\s*$} $text -> n]} {
        set cur [dict create]
        if {[info exists ::teuk::chatgpt::hist_overrides($nick)]} { set cur $::teuk::chatgpt::hist_overrides($nick) }
        set ::teuk::chatgpt::hist_overrides($nick) [dict merge $cur [dict create max_answer_chars $n]]
        puthelp "NOTICE $nick :max_answer_chars=$n pour $nick"
        return
    }

    if {[regexp -nocase -- {^gptset\s+prompt(?:\s+(.*))?\s*$} $text -> p]} {
        if {![info exists p]} { set p "" }
        set r [::teuk::chatgpt::_set_system_prompt $nick $p]
        puthelp "NOTICE $nick :$r (target=$nick)"
        return
    }

    if {[regexp -nocase -- {^gptecho\s+(user|assistant)\s+(.+)$} $text -> role payload]} {
        ::teuk::chatgpt::_hist_add $nick $role $payload
        puthelp "NOTICE $nick :ajout contexte ($role): [string range $payload 0 80]"
        return
    }
}
bind msg -|- gptreset ::teuk::chatgpt::msg_aux
bind msg -|- gptset   ::teuk::chatgpt::msg_aux
bind msg -|- gptecho  ::teuk::chatgpt::msg_aux

proc teuk::chatgpt::setkey {k} { set ::teuk::chatgpt::api_key $k }
proc teuk::chatgpt::setcurl {v} { set ::teuk::chatgpt::prefer_curl [expr {($v ne "0")}]; return "OK prefer_curl=$::teuk::chatgpt::prefer_curl" }

catch { ::teuk::chatgpt::_db_load }

putlog "chatgpt: script chatGPT v$::teuk::chatgpt::version charge (auteur: Te\[u]K, aide: MenzAgitat). Commande !chatgpt, chanset +chatgpt requis."
bind evnt - prerehash ::teuk::chatgpt::unload
